;
;***********************
;    DEMO TIMER 8253   *
;     EXPERIMENT 12    *
;***********************

         CPU  "Z180.TBL"
         HOF  "INT8"

         ORG  8000H

CWD:     EQU  0BFH
CH0:     EQU  0BCH
CTRL:    EQU  0BBH
GATE:    EQU  0B8H
RST38H:  EQU  0FFBBH
DMSEC:   EQU  012EH
SEGM:    EQU  0B9H
LED:     EQU  0BAH
V_TIME:  EQU  5000

         DI
         LD   A,0
         LD   (B_INT),A
         LD   A,80H
         OUT  (CTRL),A
         LD   HL,INT
         LD   (RST38H),HL
         LD   A,00010111B
         OUT  (CWD),A
         LD   A,200
         OUT  (CH0),A
         LD   HL,V_TIME
         LD   (TIME),HL

         LD   D,1
         LD   A,1
         OUT  (GATE),A
         EI

LOOP:    OUT0 (LED),D
         LD   B,50
         CALL DMSEC
         RLC  D
         JR   LOOP
;
INT:     DI
         PUSH  AF
         PUSH  BC
         PUSH  HL

         LD    HL,(TIME)
         DEC   HL
         LD    (TIME),HL
         LD    A,H
         OR    L
         JR    NZ,INT1
         LD    HL,V_TIME
         LD    (TIME),HL
         LD    A,(B_INT)
         ADD   A,1
         DAA
         AND   0FH
         LD    (B_INT),A
         LD    HL,TABLE
         LD    C,A
         LD    B,0
         ADD   HL,BC
         LD    A,(HL)
         OUT   (SEGM),A

INT1:    POP   HL
         POP   BC
         POP   AF
         EI
         RET
;
TABLE:   DFB  3FH,06H,5BH,4FH
         DFB  66H,6DH,7DH,07H
         DFB  7FH,6FH

         ORG   0F000H
B_INT:   DFS   1
B_DATA:  DFS   1
TIME:    DFS   1

